/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.plan;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.plan.Bubble;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceActivityVisitor;
import cz.insophy.inplan.shop.RebuildType;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.util.BiPeekingIterator;
import cz.insophy.inplan.util.Iterators2;
import cz.insophy.inplan.util.TimeSpan;
import cz.insophy.inplan.util.list.SortedList;
import cz.insophy.inplan.util.list.SortedLists;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang.NotImplementedException;

public class WorkplaceSchedule {
    private final Workplace workplace;
    private final SortedList<WorkplaceActivity> activities;
    private final SortedList<WorkplaceActivity> rebuilds;
    private static final WaComparator WA_COMPARATOR = new WaComparator();

    public WorkplaceSchedule(Workplace workplace) {
        this.workplace = workplace;
        this.activities = SortedLists.create(WA_COMPARATOR);
        this.rebuilds = SortedLists.create(WA_COMPARATOR);
    }

    public Workplace getWorkplace() {
        return this.workplace;
    }

    public void addActivity(WorkplaceActivity activity) {
        if (activity.getWorkplace() != this.workplace) {
            throw new IllegalStateException(activity + " cannot be assigned to other workplace than " + this.workplace);
        }
        this.activities.add(activity);
        if (activity instanceof RebuildActivity) {
            this.rebuilds.add(activity);
        }
    }

    public void removeActivity(WorkplaceActivity activity) {
        if (activity.getWorkplace() != this.workplace) {
            throw new IllegalStateException(activity + " is not part of " + this.workplace);
        }
        this.activities.remove(activity);
        if (activity instanceof RebuildActivity) {
            this.rebuilds.remove(activity);
        }
    }

    public WorkplaceActivity getActivity(long time) {
        return this.getActivity(time, ActivityMatch.EXCLUSIVE);
    }

    public WorkplaceActivity getActivity(long time, ActivityMatch mode) {
        WorkplaceActivity wa;
        boolean sI = mode == ActivityMatch.START_INCLUSIVE;
        boolean eI = mode == ActivityMatch.END_INCLUSIVE;
        WorkplaceActivity res = null;
        BiPeekingIterator iter = (BiPeekingIterator)this.forwardIterator(time, true);
        if (iter.hasNext()) {
            wa = (WorkplaceActivity)iter.next();
            if (sI && wa.getStart() <= time || !sI && wa.getStart() < time) {
                res = wa;
            } else {
                iter.previous();
            }
        }
        if (res == null && iter.hasPrevious()) {
            wa = (WorkplaceActivity)iter.previous();
            if (eI && wa.getEnd() >= time || !eI && wa.getEnd() > time) {
                res = wa;
            }
        }
        return res;
    }

    public WorkplaceActivity getActivityStartIncl(long time) {
        return this.getActivity(time, ActivityMatch.START_INCLUSIVE);
    }

    public WorkplaceActivity getActivityEndIncl(long time) {
        return this.getActivity(time, ActivityMatch.END_INCLUSIVE);
    }

    public Iterator<WorkplaceActivity> backwardIterator(long time) {
        return this.backwardIterator(time, false);
    }

    public Iterator<WorkplaceActivity> backwardIterator(long time, boolean inclusive) {
        BiPeekingIterator<WorkplaceActivity> iter = this.activities.iterator(new DummyActivity(time));
        if (!inclusive && iter.hasPrevious() && iter.peekPrevious().getEnd() > time) {
            iter.previous();
        }
        return Iterators2.reverse(iter);
    }

    public Iterator<WorkplaceActivity> backwardIteratorWithBubbles(long time, boolean inclusive) {
        return new BackwardIteratorWithBubbles(time, inclusive, false);
    }

    public Iterator<WorkplaceActivity> backwardIteratorWithBubblesCut(long time) {
        return new BackwardIteratorWithBubbles(time, true, true);
    }

    public Iterator<WorkplaceActivity> forwardIteratorWithBubbles(long time, boolean inclusive) {
        return new ForwardIteratorWithBubbles(time, inclusive, false);
    }

    public Iterator<WorkplaceActivity> forwardIteratorWithBubblesCut(long time) {
        return new ForwardIteratorWithBubbles(time, true, true);
    }

    public BiPeekingIterator<WorkplaceActivity> iteratorWithBubbles(long time) {
        return new IteratorWithBubbles(time, this.activities.iterator(new DummyActivity(time)), this.workplace);
    }

    public Iterable<WorkplaceActivity> activities() {
        return new Iterable<WorkplaceActivity>(){

            @Override
            public Iterator<WorkplaceActivity> iterator() {
                return WorkplaceSchedule.this.forwardIterator();
            }
        };
    }

    public List<WorkplaceActivity> getActivities() {
        return this.activities;
    }

    public Iterator<WorkplaceActivity> forwardIterator() {
        return this.forwardIterator(Long.MIN_VALUE, false);
    }

    public Iterator<WorkplaceActivity> forwardIterator(long time) {
        return this.forwardIterator(time, false);
    }

    public Iterator<WorkplaceActivity> forwardIterator(long time, boolean inclusive) {
        BiPeekingIterator<WorkplaceActivity> iter = this.activities.iterator(new DummyActivity(time));
        if (inclusive && iter.hasPrevious() && iter.peekPrevious().getEnd() > time) {
            iter.previous();
        }
        return iter;
    }

    public WorkplaceActivity getNextActivity(long time) {
        Iterator<WorkplaceActivity> it = this.forwardIterator(time, false);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public WorkplaceActivity getPrevActivity(long time) {
        Iterator<WorkplaceActivity> it = this.backwardIterator(time, false);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public int getActivityCount() {
        return this.activities.size();
    }

    protected void preUpdateActivity(WorkplaceActivity activity) {
        if (!this.activities.remove(activity)) {
            throw new IllegalArgumentException("Activity whose udpate was requested is not in the schedule.");
        }
    }

    protected void postUpdateActivity(WorkplaceActivity activity) {
        this.activities.add(activity);
    }

    public TimeSpan getTimeBounds() {
        if (this.getActivityCount() > 0) {
            long firstStart = ((WorkplaceActivity)this.activities.get(0)).getStart();
            long lastEnd = ((WorkplaceActivity)this.activities.get(this.activities.size() - 1)).getEnd();
            return TimeSpan.fromStartEnd(firstStart, lastEnd);
        }
        return TimeSpan.EMPTY;
    }

    public String getRebuildTypeNameAt(long time) {
        String type = null;
        BiPeekingIterator<WorkplaceActivity> it = this.rebuilds.iterator(new DummyActivity(time));
        while (it.hasPrevious()) {
            WorkplaceActivity prevReb = it.previous();
            if (prevReb.getEnd() > time) continue;
            type = ((RebuildActivity)prevReb).getTo();
            break;
        }
        return type;
    }

    public RebuildType getRebuildTypeAt(long time) {
        String rname = this.getRebuildTypeNameAt(time);
        if (rname == null) {
            return null;
        }
        return this.workplace.getRebuildType(rname);
    }

    public long getMinActivityStart(long time, WorkplaceActivity omitActivity) {
        WorkplaceActivity currentAct = this.getActivity(time);
        if (currentAct != null && currentAct != omitActivity) {
            return Long.MAX_VALUE;
        }
        WorkplaceActivity prevActivity = this.getPrevActivity(time);
        while (prevActivity == omitActivity) {
            prevActivity = this.getPrevActivity(omitActivity.getStart());
        }
        long minStart = prevActivity == null ? Long.MIN_VALUE : prevActivity.getEnd();
        return minStart;
    }

    public long getMaxActivityEnd(long time, WorkplaceActivity omitActivity) {
        WorkplaceActivity currentAct = this.getActivity(time);
        if (currentAct != null && currentAct != omitActivity) {
            return Long.MIN_VALUE;
        }
        WorkplaceActivity nextActivity = this.getNextActivity(time);
        while (nextActivity == omitActivity) {
            nextActivity = this.getNextActivity(omitActivity.getEnd());
        }
        long maxEnd = nextActivity == null ? Long.MAX_VALUE : nextActivity.getStart();
        return maxEnd;
    }

    public void visitActivities(long from, long to, WorkplaceActivityVisitor visitor) {
        if (to >= from) {
            WorkplaceActivity wa;
            Iterator<WorkplaceActivity> iter = this.forwardIteratorWithBubbles(from, true);
            while (iter.hasNext() && (wa = iter.next()).getStart() < to) {
                wa.accept(visitor);
            }
        }
    }

    private static class WaComparator
    implements Comparator<WorkplaceActivity> {
        private WaComparator() {
        }

        @Override
        public int compare(WorkplaceActivity wa1, WorkplaceActivity wa2) {
            return wa1.getStart() < wa2.getStart() ? -1 : (wa1.getStart() == wa2.getStart() ? 0 : 1);
        }
    }

    public static enum ActivityMatch {
        START_INCLUSIVE,
        END_INCLUSIVE,
        EXCLUSIVE;

    }

    private static final class DummyActivity
    extends WorkplaceActivity {
        public DummyActivity(long time) {
            super(time);
        }

        @Override
        public Activity duplicate() {
            throw new IllegalStateException();
        }

        @Override
        void accept(WorkplaceActivityVisitor visitor) {
        }
    }

    private class BackwardIteratorWithBubbles
    implements Iterator<WorkplaceActivity> {
        private final BiPeekingIterator<WorkplaceActivity> it;
        private WorkplaceActivity wa;
        private long bubbleEnd;
        private boolean isOver = false;

        public BackwardIteratorWithBubbles(long time, boolean inclusive, boolean cutFirstBubble) {
            if (!inclusive && cutFirstBubble) {
                throw new IllegalArgumentException("cutFirstBubble possible only in inclusive mode.");
            }
            this.it = (BiPeekingIterator)WorkplaceSchedule.this.backwardIterator(time, inclusive);
            if (this.it.hasNext()) {
                this.wa = (WorkplaceActivity)this.it.next();
                WorkplaceActivity wa2 = null;
                this.it.previous();
                if (this.it.hasPrevious()) {
                    wa2 = this.it.previous();
                    this.it.next();
                }
                this.it.next();
                if (inclusive) {
                    if (this.wa.getEnd() < time) {
                        this.bubbleEnd = wa2 != null ? wa2.getStart() : Long.MAX_VALUE;
                        this.wa = null;
                        this.it.previous();
                    }
                } else if (wa2 != null && wa2.getStart() <= time && this.wa.getEnd() < wa2.getStart()) {
                    this.bubbleEnd = wa2.getStart();
                    this.wa = null;
                    this.it.previous();
                }
            } else {
                if (inclusive) {
                    if (this.it.hasPrevious()) {
                        this.wa = this.it.previous();
                        this.bubbleEnd = this.wa.getStart();
                        this.it.next();
                    } else {
                        this.bubbleEnd = Long.MAX_VALUE;
                    }
                } else {
                    this.isOver = true;
                    if (this.it.hasPrevious()) {
                        this.wa = this.it.previous();
                        if (this.wa.getStart() < time) {
                            this.bubbleEnd = this.wa.getStart();
                            this.isOver = false;
                        }
                        this.it.next();
                    }
                }
                this.wa = null;
            }
            if (cutFirstBubble && this.wa == null && this.bubbleEnd > time) {
                this.bubbleEnd = time;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.isOver;
        }

        @Override
        public WorkplaceActivity next() {
            WorkplaceActivity res = null;
            if (this.wa == null) {
                if (this.it.hasNext()) {
                    this.wa = (WorkplaceActivity)this.it.next();
                    long bubbleStart = this.wa.getEnd();
                    if (bubbleStart < this.bubbleEnd) {
                        res = new Bubble(bubbleStart, this.bubbleEnd, WorkplaceSchedule.this.workplace);
                    }
                } else {
                    if (this.isOver) {
                        throw new NoSuchElementException();
                    }
                    res = new Bubble(Long.MIN_VALUE, this.bubbleEnd, WorkplaceSchedule.this.workplace);
                    this.isOver = true;
                }
            }
            if (res == null) {
                res = this.wa;
                this.bubbleEnd = this.wa.getStart();
                this.wa = null;
            }
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ForwardIteratorWithBubbles
    implements Iterator<WorkplaceActivity> {
        private final BiPeekingIterator<WorkplaceActivity> it;
        private WorkplaceActivity wa;
        private long bubbleStart;
        private boolean isOver = false;

        public ForwardIteratorWithBubbles(long time, boolean inclusive, boolean cutFirstBubble) {
            Preconditions.checkArgument(time != Long.MAX_VALUE, "time must be finite");
            this.it = (BiPeekingIterator)WorkplaceSchedule.this.forwardIterator(time, inclusive);
            if (this.it.hasNext()) {
                this.wa = (WorkplaceActivity)this.it.next();
                WorkplaceActivity wa2 = null;
                this.it.previous();
                if (this.it.hasPrevious()) {
                    wa2 = this.it.previous();
                    this.it.next();
                }
                this.it.next();
                if (inclusive) {
                    if (time < this.wa.getStart()) {
                        this.bubbleStart = wa2 != null ? wa2.getEnd() : Long.MIN_VALUE;
                        this.wa = null;
                        this.it.previous();
                    }
                } else if (wa2 != null && wa2.getEnd() >= time && wa2.getEnd() < this.wa.getStart()) {
                    this.bubbleStart = wa2.getEnd();
                    this.wa = null;
                    this.it.previous();
                }
            } else {
                if (inclusive) {
                    if (this.it.hasPrevious()) {
                        this.wa = this.it.previous();
                        this.bubbleStart = this.wa.getEnd();
                        this.it.next();
                    } else {
                        this.bubbleStart = Long.MIN_VALUE;
                    }
                } else {
                    this.isOver = true;
                    if (this.it.hasPrevious()) {
                        this.wa = this.it.previous();
                        if (this.wa.getEnd() >= time) {
                            this.bubbleStart = this.wa.getEnd();
                            this.isOver = false;
                        }
                        this.it.next();
                    }
                }
                this.wa = null;
            }
            if (cutFirstBubble && this.wa == null && this.bubbleStart < time) {
                this.bubbleStart = time;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.isOver;
        }

        @Override
        public WorkplaceActivity next() {
            WorkplaceActivity res = null;
            if (this.wa == null) {
                if (this.it.hasNext()) {
                    this.wa = (WorkplaceActivity)this.it.next();
                    long bubbleEnd = this.wa.getStart();
                    if (this.bubbleStart < bubbleEnd) {
                        res = new Bubble(this.bubbleStart, bubbleEnd, WorkplaceSchedule.this.workplace);
                    }
                } else {
                    if (this.isOver) {
                        throw new NoSuchElementException();
                    }
                    res = new Bubble(this.bubbleStart, Long.MAX_VALUE, WorkplaceSchedule.this.workplace);
                    this.isOver = true;
                }
            }
            if (res == null) {
                res = this.wa;
                this.bubbleStart = this.wa.getEnd();
                this.wa = null;
            }
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class IteratorWithBubbles
    implements BiPeekingIterator<WorkplaceActivity> {
        private WorkplaceActivity prev;
        private WorkplaceActivity next;
        private final BiPeekingIterator<WorkplaceActivity> iter;
        private final Workplace workplace;

        public IteratorWithBubbles(long time, BiPeekingIterator<WorkplaceActivity> biPeekingIterator, Workplace workplace) {
            this.iter = biPeekingIterator;
            this.workplace = workplace;
            if (this.iter.hasNext()) {
                this.next = this.iter.peekNext();
            }
            if (this.iter.hasPrevious()) {
                this.prev = this.iter.peekPrevious();
                if (this.prev.getEnd() > time) {
                    this.next = this.prev;
                    this.iter.previous();
                    this.prev = this.iter.hasPrevious() ? this.iter.peekPrevious() : null;
                }
            }
            if (this.next == null && this.prev == null) {
                this.next = new Bubble(Long.MIN_VALUE, Long.MAX_VALUE, workplace);
            } else if (this.next == null) {
                this.next = new Bubble(this.prev.getEnd(), Long.MAX_VALUE, workplace);
            } else if (this.prev == null) {
                if (this.next.getStart() > time) {
                    this.next = new Bubble(Long.MIN_VALUE, this.next.getStart(), workplace);
                } else {
                    this.prev = new Bubble(Long.MIN_VALUE, this.next.getStart(), workplace);
                    this.iter.next();
                }
            } else if (this.prev.getEnd() != this.next.getStart()) {
                if (this.next.getStart() > time) {
                    this.next = new Bubble(this.prev.getEnd(), this.next.getStart(), workplace);
                } else {
                    this.prev = new Bubble(this.prev.getEnd(), this.next.getStart(), workplace);
                    this.iter.next();
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            return this.prev != null;
        }

        @Override
        public WorkplaceActivity next() {
            long nextStart;
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            while (this.iter.hasNext() && this.iter.peekNext().getStart() <= this.next.getStart()) {
                this.iter.next();
            }
            this.prev = this.next;
            this.next = this.iter.hasNext() ? ((nextStart = this.iter.peekNext().getStart()) == this.prev.getEnd() ? (WorkplaceActivity)this.iter.next() : new Bubble(this.prev.getEnd(), nextStart, this.workplace)) : (this.prev instanceof Bubble ? null : new Bubble(this.prev.getEnd(), Long.MAX_VALUE, this.workplace));
            return this.prev;
        }

        @Override
        public WorkplaceActivity previous() {
            long prevEnd;
            if (this.prev == null) {
                throw new NoSuchElementException();
            }
            while (this.iter.hasPrevious() && this.iter.peekPrevious().getEnd() >= this.prev.getEnd()) {
                this.iter.previous();
            }
            this.next = this.prev;
            this.prev = this.iter.hasPrevious() ? ((prevEnd = this.iter.peekPrevious().getEnd()) == this.next.getStart() ? this.iter.previous() : new Bubble(prevEnd, this.next.getStart(), this.workplace)) : (this.next instanceof Bubble ? null : new Bubble(Long.MIN_VALUE, this.next.getStart(), this.workplace));
            return this.next;
        }

        @Override
        public WorkplaceActivity peekNext() {
            if (this.next != null) {
                return this.next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public WorkplaceActivity peekPrevious() {
            if (this.prev != null) {
                return this.prev;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("prev", this.prev).add("next", this.next).toString();
        }
    }
}

